/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.registry;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentOption;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class TalentInstance
implements IDogAlteration {
    protected final Talent talent;
    protected int level;

    public TalentInstance(Talent talentIn) {
        this(talentIn, 1);
    }

    public TalentInstance(Talent talentIn, int levelIn) {
        this.talent = talentIn;
        this.level = levelIn;
    }

    public Talent getTalent() {
        return this.talent;
    }

    public final int level() {
        return this.level;
    }

    public final void setLevel(int levelIn) {
        this.level = levelIn;
    }

    public boolean of(Supplier<Talent> talentIn) {
        return this.of(talentIn.get());
    }

    public boolean of(Talent talentIn) {
        return talentIn == this.talent;
    }

    public TalentInstance copy() {
        TalentInstance ret = this.talent.getDefault(this.level);
        ret.copyTalentOptionFrom(this);
        return ret;
    }

    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
    }

    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
    }

    public final void doReadFromNBT(AbstractDog dogIn, CompoundTag compound) {
        this.setLevel(compound.m_128451_("level"));
        this.readFromNBT(dogIn, compound);
    }

    public final void doWriteToNBT(AbstractDog dogIn, CompoundTag compound) {
        compound.m_128405_("level", this.level());
        this.writeToNBT(dogIn, compound);
    }

    public final void writeToBuf(FriendlyByteBuf buf, BiConsumer<FriendlyByteBuf, TalentOption<?>> talent_option_writer) {
        buf.writeInt(this.level());
        Collection<TalentOption<?>> talent_options = this.getAllTalentOptions();
        if (talent_options.isEmpty()) {
            buf.writeInt(0);
            return;
        }
        buf.writeInt(talent_options.size());
        for (TalentOption<?> entry : talent_options) {
            talent_option_writer.accept(buf, entry);
            this.writeTalentOptionToBuf(buf, entry);
        }
    }

    private <T> void writeTalentOptionToBuf(FriendlyByteBuf buf, TalentOption<T> entry) {
        T value = this.getTalentOptionOrDefault(entry);
        entry.encode(buf, value);
    }

    public final void readFromBuf(FriendlyByteBuf buf, Function<FriendlyByteBuf, TalentOption<?>> talent_option_reader) {
        this.setLevel(buf.readInt());
        int talent_options_size = buf.readInt();
        if (talent_options_size <= 0) {
            return;
        }
        for (int i = 0; i < talent_options_size; ++i) {
            TalentOption<?> entry = talent_option_reader.apply(buf);
            this.readTalentOptionFromBuf(buf, entry);
        }
    }

    private <T> void readTalentOptionFromBuf(FriendlyByteBuf buf, TalentOption<T> entry) {
        T value = entry.decode(buf);
        if (value == null) {
            value = entry.getDefault();
        }
        this.setTalentOption(entry, value);
    }

    public final void writeInstance(AbstractDog dogIn, CompoundTag compound) {
        ResourceLocation rl = DoggyTalentsAPI.TALENTS.get().getKey((Object)this.talent);
        if (rl != null) {
            compound.m_128359_("type", rl.toString());
        }
        this.doWriteToNBT(dogIn, compound);
    }

    public static Optional<TalentInstance> readInstance(AbstractDog dogIn, CompoundTag compound) {
        ResourceLocation rl = ResourceLocation.m_135820_((String)compound.m_128461_("type"));
        if (DoggyTalentsAPI.TALENTS.get().containsKey(rl)) {
            TalentInstance inst = ((Talent)DoggyTalentsAPI.TALENTS.get().getValue(rl)).getDefault();
            inst.doReadFromNBT(dogIn, compound);
            return Optional.of(inst);
        }
        DoggyTalentsAPI.LOGGER.warn("Failed to load talent {}", (Object)rl);
        return Optional.empty();
    }

    public <T extends TalentInstance> T cast(Class<T> type) {
        if (this.getClass().isAssignableFrom(type)) {
            return (T)this;
        }
        throw new RuntimeException("Could not cast " + this.getClass().getName() + " to " + type.getName());
    }

    public String toString() {
        return String.format("%s [talent: %s, level: %d]", this.getClass().getSimpleName(), DoggyTalentsAPI.TALENTS.get().getKey((Object)this.talent), this.level);
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    public void set(AbstractDog dog, int levelBefore) {
    }

    public final <T> T getTalentOptionOrDefault(TalentOption<T> entry) {
        Object val = this.getTalentOption(entry);
        if (val == null) {
            val = entry.getDefault();
        }
        return (T)val;
    }

    public Object getTalentOption(TalentOption<?> entry) {
        return null;
    }

    public void setTalentOption(TalentOption<?> entry, Object data) {
    }

    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of();
    }

    public void copyTalentOptionFrom(TalentInstance other) {
        Collection<TalentOption<?>> entries = this.getAllTalentOptions();
        if (entries.isEmpty()) {
            return;
        }
        for (TalentOption<?> entry : entries) {
            this.doCopyTalentOption(other, entry);
        }
    }

    private <T> void doCopyTalentOption(TalentInstance other, TalentOption<T> entry) {
        T val = other.getTalentOptionOrDefault(entry);
        this.setTalentOption(entry, val);
    }

    public boolean hasRenderer() {
        return this.getTalent().hasRenderer();
    }
}

